!Object constantsFor: 'Geos Libraries'!

geosLIB52 'SYSTEM\parse'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

ParserGetNumberOfFunctions: funcType
	"word pascal ParserGetNumberOfFunctions(FunctionType funcType) in parse.h"
	^GEOS call: funcType with: #[52 0 25 1 1]!

ParserGetFunctionMoniker: funcID with: funcType with: textPtr
	"word pascal ParserGetFunctionMoniker(FunctionID funcID, FunctionType funcType, char *textPtr) in parse.h"
	^GEOS call: funcID with: funcType with: textPtr with: #[52 0 26 1 1 3 1]!

ParserGetFunctionArgs: funcID with: funcType with: textPtr
	"word pascal ParserGetFunctionArgs(FunctionID funcID, FunctionType funcType, char *textPtr) in parse.h"
	^GEOS call: funcID with: funcType with: textPtr with: #[52 0 35 1 1 3 1]!

ParserGetFunctionDescription: funcID with: funcType with: textPtr
	"word pascal ParserGetFunctionDescription(FunctionID funcID, FunctionType funcType, char *textPtr) in parse.h"
	^GEOS call: funcID with: funcType with: textPtr with: #[52 0 36 1 1 3 1]!

ParserFormatColumnReference: colNum with: buffer with: bufferSize
	"void pascal ParserFormatColumnReference (word colNum, char *buffer, word bufferSize) in parse.h"
	^GEOS call: colNum with: buffer with: bufferSize with: #[52 0 27 1 3 1 0]!

ParserParseString: textBuffer with: tokenBuffer with: parserParams with: retval
	"int pascal ParserParseString (char *textBuffer, byte *tokenBuffer, CParserStruct *parserParams, CParserReturnStruct *retval) in parse.h"
	^GEOS call: textBuffer with: tokenBuffer with: parserParams with: retval with: #[52 0 28 3 3 3 3 4]!

ParserFormatExpression: tokenBuffer with: textBuffer with: formatParams
	"int pascal ParserFormatExpression (byte *tokenBuffer, char *textBuffer, CFormatStruct *formatParams) in parse.h"
	^GEOS call: tokenBuffer with: textBuffer with: formatParams with: #[52 0 29 3 3 3 4]!

ParserEvalExpression: tokenBuffer with: scratchBuffer with: resultsBuffer with: bufSize with: evalParams
	"int pascal ParserEvalExpression (byte *tokenBuffer, byte *scratchBuffer, byte *resultsBuffer, word bufSize, CEvalStruct *evalParams) in parse.h"
	^GEOS call: tokenBuffer with: scratchBuffer with: resultsBuffer with: bufSize with: evalParams with: #[52 0 30 3 3 3 1 3 4]!

!

